function svgstem(fid, x, y, varargin)

% default values
stroke='red';
stroke_width=1;
common_Y=0;
radius=3;

% parameter handling
for argindex=1:2:length(varargin)
  arg=varargin{argindex};
  param=varargin{argindex+1};
  switch(arg)
   case 'stroke'
    stroke=param;
   case 'stroke_width'
    stroke_width=param;
   case 'common_Y'
    common_Y=param;
   case 'radius'
    radius=param;
   otherwise
    error(['invalid parameter at position ', mat2str(argindex)]);
  end % switch
end % for argindex

% function body
if rows(x) != 1
  error('need row vector for x');
elseif rows(y) != 1  
  error('need row vector for y');
elseif columns(x) != columns(y)
  error('need same length in x and y');
end

for index=1:columns(x)
  xi=x(index);
  yi=y(index);
  fprintf(fid, '<polyline points="')
  fprintf(fid, '%i,%i %i,%i', xi, common_Y, xi, yi);
  fprintf(fid, '%s', '" style="fill:none;');
  fprintf(fid, 'stroke:%s;stroke-width:%i"/>', stroke, stroke_width);
  fprintf(fid, '<circle ')
  fprintf(fid, 'cx="%f" cy="%f" r="%f" stroke="%s" stroke-width="%i" ', xi, yi, radius, stroke, stroke_width);
  fprintf(fid, '%s', 'fill="none"/>');
end
